﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Web;
using Soneta.Business;
using Soneta.Core;
using Soneta.EwidencjaVat;
using Soneta.Handel.Forms;
using Soneta.Kasa;
using Soneta.Tools;
using Soneta.Types;
using Soneta.Web;

namespace ASP
{
    public partial class Ewidencja_VAT : System.Web.UI.Page {
        public string Str_CaptionDataRoz = "Data roz.";
        public string Str_TytulRejestrVat = "Rejestr VAT";
        public string Str_TytulEwidencjaVat = "Ewidencja VAT";
        public string Str_Netto = "Netto {0}";
        public string Str_TytulFormat = "{0}{10} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, {11} Podmiot: {4}, Korekty: {5} |Działalność: {12}, Odliczenia: {6}|Rodzaj: {7}, Rodzaj pod.: {8}, Status pod.: {9}";
        public string Str_Wszystkie = "Wszystkie";
        public string Str_Wszyscy = "Wszyscy";
        public string Str_TypRozliczenia = "Typ rozliczenia: {0},";
        public string Str_KwotaBrutto = "{0} | Kwota brutto {1} {2:n}";
        public string Str_OkresRozVat = "| Okres roz. VAT: {0}";
        public string Str_OkresKsiegowania = "| Okres księgowania: {0}";
        public string Str_Podsumowanie = "Podsumowanie --- {0}";
        public string Str_Grid1GroupLine = "DELTRA";
        public string Str_Grid1GroupSumText = "Dla grupy";
        public string Str_BezOddzialu = "(bez oddziału)";
        public bool WersjaPL = true;


        //----------
        private Boolean agregacjaWgOddzialuSlownikowego = false;
		private Boolean wydrukTekstowy = false;
	
		private SortedList podsumowanie = null;
		private PodsumowanieVATEx podsumowanieWorker = new PodsumowanieVATEx();
		private List<Tuple<GridColumn, Func<PodsumowanieVATEx, Decimal>>> dynamicColumns = new List<Tuple<GridColumn, Func<PodsumowanieVATEx, Decimal>>>();

		
		private String WrapAny(String str)
		{ return String.Format("<span style='word-break:break-all;'>{0}</span>", System.Web.HttpUtility.HtmlEncode(str)); }


		protected void Grid1_BeforeRow(object sender, RowEventArgs args)
		{
			INaglowekVAT nag = (INaglowekVAT)args.Row;
			DokEwidencji ewid = nag.Ewidencja;
			
			if (Param.Zaplacone)
			{
				Date data = Date.MaxValue;
				string dokumenty = "";
				foreach (Platnosc p in ewid.Platnosci)
				{
					if (!(p.DataRozliczenia < Date.MaxValue))
					{
						args.VisibleRow = false;
						return;
					}

					data = Date.Min(p.DataRozliczenia, data);
					dokumenty += p.RozliczoneDokumenty;
				}
				colZaplaty.EditValue = string.Format("{0} - {1}", data, dokumenty);
			}

			if (Param.OpisUslugi)
				colOpisyUslug.EditValue = ((VATEwidencja)ewid).OpisVATUslug;

			if (Param.OkresRozliczeniaVAT != FromTo.All)
			{
				NagRozliczeniaVAT nagRoz = nag as NagRozliczeniaVAT;
				if (nagRoz != null && !Param.OkresRozliczeniaVAT.Contains(nagRoz.Data))
				{
					args.VisibleRow = false;
					return;
				}

				NagEwidencjiVAT nagEwid = nag as NagEwidencjiVAT;
				if (nagEwid != null)
				{
					if (nagEwid.NaglowkiRozliczeniaVAT.IsEmpty)
					{
						args.VisibleRow = false;
						return;
					}
					foreach (NagRozliczeniaVAT n in nagEwid.NaglowkiRozliczeniaVAT)
					{
						if (!Param.OkresRozliczeniaVAT.Contains(n.Data))
						{
							args.VisibleRow = false;
							return;
						}
					}
				}
			}

			if (Param.OkresKsiegowania != FromTo.All && !Param.OkresKsiegowania.Contains(nag.Ewidencja.DataKsiegowania))
			{
				args.VisibleRow = false;
				return;
			}

			colNumer.EditValue = WrapAny(nag.Numer);
			colNumerDokumentu.EditValue = WrapAny(nag.NumerDokumentu);
			colDataDokumentu.EditValue = nag.DataDokumentu;
			colDefinicja.EditValue = nag.Definicja.Symbol;

			DaneKontrahenta danePodmiotu = ((PodmiotEwidencja)nag.Ewidencja).DaneKontrahenta;

			string nip = "";
			if (danePodmiotu.EuVAT != "")
                nip += string.Format("{0} {1}", danePodmiotu.EuVAT, danePodmiotu.Adres);
			colNip.EditValue = nip;
            colNazwa.EditValue = string.Format("{0}\n{1} {2}", danePodmiotu.Nazwa, danePodmiotu.EuVAT, danePodmiotu.Adres);

			podsumowanieWorker.Naglowek = nag;
			colNettoZw.EditValue = podsumowanieWorker.SumaWgStawek["ZW"].Netto.Value;
			colNetto0.EditValue = podsumowanieWorker.SumaWgStawek["0%"].Netto.Value;
			colNettoNP.EditValue = podsumowanieWorker.SumaWgStawek["NP"].Netto.Value;
            colNettoBrak.EditValue = podsumowanieWorker.SumaWgStawek["-"].Netto.Value;
			colNetto.EditValue = podsumowanieWorker.Suma.Netto.Value;
			colVAT.EditValue = podsumowanieWorker.Suma.VAT.Value;
			colBrutto.EditValue = podsumowanieWorker.Suma.Brutto.Value;

			foreach (var dynCol in dynamicColumns)
				dynCol.Item1.EditValue = dynCol.Item2(podsumowanieWorker);

			if (Param.SposobSumowania != SposobSumowania.Brak)
			{
				object grpKey = calcGroupKey(nag);

				if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
					Grid1.GroupLine = grpKey.ToString();

				if (podsumowanie.ContainsKey(grpKey))
					((Podsumowanie)podsumowanie[grpKey]).Add(podsumowanieWorker);
				else
				{
					Podsumowanie pod = new Podsumowanie(grpKey);
					pod.Add(podsumowanieWorker);
					podsumowanie.Add(grpKey, pod);
				}
			}
		}


		public class ProxyOdddzial
        {

            private readonly OddzialFirmy odd;
			private readonly String symbol;
            
			public String Symbol
			{ get { return symbol; } }

			public override string ToString()
			{ return Symbol; }

			public ProxyOdddzial(OddzialFirmy o, string Str_BezOddzialu)
			{
				odd = o;
				symbol = o != null ? o.Symbol : Str_BezOddzialu;
			}
		}


		public class ProxyCust : IComparable<ProxyCust>
		{
			private readonly String country;
			private readonly String nip;

			
			public ProxyCust(INaglowekVAT nag)
			{
				EuVat.Split(nag.Podmiot.EuVAT, out country, out nip);
				nip = EuVat.Flat(nip);
			}

			
			public override string ToString()
			{ return String.IsNullOrEmpty(country) ? nip : country + "-" + nip; }


			public int CompareTo(ProxyCust other)
			{
				if (other == null)
					throw new ArgumentNullException("ProxyCust.CompareTo.other");

				int comp;
				
				if ((comp = country.CompareTo(other.country)) != 0)
					return comp;
				if ((comp = nip.CompareTo(other.nip)) != 0)
					return comp;

				return 0;				
			}
		}


		private object calcGroupKey(INaglowekVAT nag)
		{
			Debug.Assert(nag != null);
			Debug.Assert(Param.SposobSumowania != SposobSumowania.Brak);

			switch (Param.SposobSumowania)
			{
				case SposobSumowania.WgMiesiącaDokumentu:
					return nag.Ewidencja.DataDokumentu.ToYearMonth();

				case SposobSumowania.WgMiesiącaEwidencji:
					return nag.Ewidencja.DataEwidencji.ToYearMonth();

				case SposobSumowania.WgMiesiącaWpływu:
					return nag.Ewidencja.DataWplywu.ToYearMonth();

				case SposobSumowania.WgMiesiącaOperacji:
					return nag.Ewidencja.DataOperacji.ToYearMonth();

				case SposobSumowania.WgMiesiącaZaewidencjonowania:
					if (nag is NagEwidencjiVAT)
						return ((NagEwidencjiVAT)nag).DataZaewidencjonowania.ToYearMonth();
					else
						return ((NagRozliczeniaVAT)nag).Naglowek.DataZaewidencjonowania.ToYearMonth();

				case SposobSumowania.WgMiesiącaRozliczenia:
					if (nag is NagEwidencjiVAT)
						return ((NagEwidencjiVAT)nag).DataRozliczenia.ToYearMonth();
					else
						return ((NagRozliczeniaVAT)nag).Data.ToYearMonth();

				case SposobSumowania.WgOddziałów:
					return new ProxyOdddzial(agregacjaWgOddzialuSlownikowego ? nag.Ewidencja.Oddzial.GetOddzialTypu(OddzialParamsType.Słownikowe, true) : nag.Ewidencja.Oddzial, Str_BezOddzialu);

				case SposobSumowania.WgPodmiotu:
					return new ProxyCust(nag);

				default:
					throw new ApplicationException("calcGroupKey::kryterium: " + Param.SposobSumowania);
			}
		}


		private int CompareNags(INaglowekVAT op1, INaglowekVAT op2)
		{
			Debug.Assert(Param.SposobSumowania != SposobSumowania.Brak);
			return KeyComparer.Instance.Compare(calcGroupKey(op1), calcGroupKey(op2));
		}


        protected void EwidencjaVAT_OnLoad(Object sender, EventArgs args)
		{
			podsumowanie = new SortedList(KeyComparer.Instance);
			
			podsumowanieWorker.Param = null;
			IEnumerable dataSource = null; 

			Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx px =(Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx) DataContext1.Context[typeof(Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx), false];
			
			if (DataContext1.Context.Contains(typeof(NagEwidencjiVATT.ParamsEx)))
				podsumowanieWorker.Param = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));

			if (podsumowanieWorker.Param == null)
			{
				podsumowanieWorker.Param = new NagEwidencjiVATT.ParamsEx(DataContext1.Context, true);
				podsumowanieWorker.Param.Typ = TypEwidencjiVAT.Sprzedaż;

				if (DataContext1.Context.Contains(typeof(DokHandloweViewInfo.WParams)))
					podsumowanieWorker.Param.Zakres = ((DokHandloweViewInfo.WParams)DataContext1.Get(typeof(DokHandloweViewInfo.WParams))).Okres;
				else
					podsumowanieWorker.Param.Zakres = ((OkresContext)DataContext1.Get(typeof(OkresContext))).Okres;

				Grid1.DataSource = dataSource = new SubTable(EwidencjaVatModule.GetInstance(DataContext1.Session).NagEwidencjiVATT.WgTyp[podsumowanieWorker.Param.Typ], podsumowanieWorker.Param.Zakres);
			}
			else
			    dataSource = (Soneta.Business.View)DataContext1.Get(typeof(Soneta.Business.View));

			if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
			{
				List<INaglowekVAT> lst = new List<INaglowekVAT>();
				foreach (INaglowekVAT nag in dataSource)
					lst.Add(nag);

				lst.Sort(CompareNags);
				Grid1.DataSource = lst;
				Grid1.RowTypeName = typeof(NagEwidencjiVAT).ToString();
			}

			string tytul = "";
			if (podsumowanieWorker.Param is NagRozliczenVATT.ParamsEx)
			{
				colData.Caption = Str_CaptionDataRoz;
				colData.DataMember = "Data";
				tytul = Str_TytulRejestrVat;
			}
			else
			{
				colData.DataMember = "DataZaewidencjonowania";
				tytul = Str_TytulEwidencjaVat;
			}

			if (wydrukTekstowy)
				colNumer.Width = 14 + 40;

			if (Param.DefinicjeStawekVAT != null && Param.DefinicjeStawekVAT.Length != 0)
			{
                int idx = Grid1.Columns.IndexOf(colNazwa);
				int idxP = Grid2.Columns.IndexOf(colMiesiac);
				foreach (DefinicjaStawkiVat defVAT in Param.DefinicjeStawekVAT)
				{
					GridColumn gcNetto = new GridColumn();
					gcNetto.Caption = string.Format(Str_Netto, defVAT.Kod);
					gcNetto.Format = "{0:n}";
					gcNetto.Width = 11;
					gcNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
                    gcNetto.VAlign = System.Web.UI.WebControls.VerticalAlign.Bottom;
                    gcNetto.Total = Soneta.Web.Total.Sum;
                    gcNetto.HideZero = true;

					String vKod = defVAT.Kod;
					dynamicColumns.Add(Tuple.Create<GridColumn, Func<PodsumowanieVATEx, Decimal>>(gcNetto, w => w.SumaWgStawek[vKod].Netto.Value));
					Grid1.Columns.Insert(++idx, gcNetto);

					GridColumn gcVAT = new GridColumn();
					gcVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					gcVAT.Format = "{0:n}";
					gcVAT.Width = 11;
					gcVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
                    gcVAT.VAlign = System.Web.UI.WebControls.VerticalAlign.Top;
					gcVAT.Total = Soneta.Web.Total.Sum;
                    gcVAT.HideZero = true;
                    
					dynamicColumns.Add(Tuple.Create<GridColumn, Func<PodsumowanieVATEx, Decimal>>(gcVAT, w => w.SumaWgStawek[vKod].VAT.Value));
					Grid1.Columns.Insert(++idx, gcVAT);

					//colNazwa.ColSpan++;
					colZaplaty.ColSpan++;
					colOpisyUslug.ColSpan++;
					if (wydrukTekstowy)
						colNumer.Width -= 11;

					GridColumn gcPNetto = new GridColumn();
					gcPNetto.Caption = string.Format(Str_Netto, defVAT.Kod);
					gcPNetto.DataMember = string.Format("{0}.Netto.Value", defVAT.Kod);
					gcPNetto.Format = "{0:n}";
					gcPNetto.Width = 11;
					gcPNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcPNetto.Total = Soneta.Web.Total.Sum;
					Grid2.Columns.Insert(++idxP, gcPNetto);

					GridColumn gcPVAT = new GridColumn();
					gcPVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					gcPVAT.DataMember = string.Format("{0}.VAT.Value", defVAT.Kod);
					gcPVAT.Format = "{0:n}";
					gcPVAT.Width = 11;
					gcPVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcPVAT.Total = Soneta.Web.Total.Sum;
					Grid2.Columns.Insert(++idxP, gcPVAT);

					colMiesiac.ColSpan++;
				}
			}

			if (!Param.Zaplacone)
			{
				Grid1.Columns.Remove(colZaplaty);
				colLp.RowSpan--;
				Grid1.RowsInRow--;
			}

			if (!Param.OpisUslugi)
			{
				Grid1.Columns.Remove(colOpisyUslug);
                //colDefinicja.RowSpan--;
                colLp.RowSpan--;
				Grid1.RowsInRow--;
                
			}


			string tytulOddzial = String.Empty;
			OddzialParamsBase opb = (OddzialParamsBase)DataContext1.Get(typeof(OddzialParamsBase));
			if (opb.OddzialowoscEnabled)
				tytulOddzial += " | Oddział: " + opb.Oddział.ToString();

			string tytulNaglowka = string.Format(Str_TytulFormat,
					tytul, 
					CaptionAttribute.EnumToString(podsumowanieWorker.Param.Typ), 
					podsumowanieWorker.Param.Zakres,
					podsumowanieWorker.Param.Definicja == null ? Str_Wszystkie : podsumowanieWorker.Param.Definicja.ToString(),
					podsumowanieWorker.Param.Podmiot == null ? Str_Wszyscy : podsumowanieWorker.Param.Podmiot.ToString(),
			        CaptionAttribute.EnumToString(podsumowanieWorker.Param.Korekty), 
					CaptionAttribute.EnumToString(podsumowanieWorker.Param.Odliczenia), 
					CaptionAttribute.EnumToString(podsumowanieWorker.Param.RodzajZakupu), 
					CaptionAttribute.EnumToString(podsumowanieWorker.Param.RodzajPodmiotu),
                    CaptionAttribute.EnumToString(podsumowanieWorker.Param.StatusPodmiotu),
					tytulOddzial,
					px != null ? String.Format(Str_TypRozliczenia, CaptionAttribute.EnumToString(px.TypRozliczenia)) : String.Empty,
        			CaptionAttribute.EnumToString(podsumowanieWorker.Param.DzialalnoscGospodarcza)
					);

			if (podsumowanieWorker.Param.Porownanie != TypPorownania.Brak)
				tytulNaglowka = string.Format(Str_KwotaBrutto, tytulNaglowka, CaptionAttribute.EnumToString(podsumowanieWorker.Param.Porownanie), podsumowanieWorker.Param.Kwota);
			if (Param.OkresRozliczeniaVAT != FromTo.All)
				tytulNaglowka += string.Format(Str_OkresRozVat, Param.OkresRozliczeniaVAT);
			if (Param.OkresKsiegowania != FromTo.All)
				tytulNaglowka += string.Format(Str_OkresKsiegowania, Param.OkresKsiegowania);

			if (Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary || Param.ZakresDruku == ZakresDrukuTp.ListSummary || Param.ZakresDruku == ZakresDrukuTp.SummaryOnly)
			{
				Grid2.DataSource = podsumowanie.Values;

			    string grupowanie = WersjaPL
			        ? CaptionAttribute.ConvertName(Param.SposobSumowania.ToString())
			        : "by " + CaptionAttribute.EnumToString(Param.SposobSumowania);

                colMiesiac.Caption =  String.Format(Str_Podsumowanie, grupowanie.ToLower());
			}
			else
			{
				Grid2.Visible = false;
			}

			if (Param.ZakresDruku == ZakresDrukuTp.SummaryOnly)
			{
				Grid1.Visible = false;
				foreach (object r in (Soneta.Business.View)DataContext1.Get(typeof(Soneta.Business.View)))
					Grid1_BeforeRow(null, new RowEventArgs(r, 0, null));
			}

			if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
			{
				Grid1.ShowAgrSum = false;
				Grid1.ShowPageSum = false;
				Grid1.ShowPrevAgrSum = PrevAgrSum.None;
				Grid1.ShowGroupSum = true;
				Grid1.GroupLine = Str_Grid1GroupLine;
				Grid1.GroupSumText = Str_Grid1GroupSumText;
			}

			if (!wydrukTekstowy)
				ReportHeader1.Title = tytulNaglowka;
		}

		
		private class KeyComparer : IComparer
		{
			public static KeyComparer Instance = new KeyComparer();


			private KeyComparer()
			{ }

			
			public int Compare(object x, object y)
			{
				if (x is YearMonth)
					return ((YearMonth)x).CompareTo((YearMonth)y);
				if (x is ProxyOdddzial)
					return ((ProxyOdddzial)x).Symbol.CompareTo(((ProxyOdddzial)y).Symbol);
				if (x is ProxyCust)
					return ((ProxyCust)x).CompareTo((ProxyCust)y);

				throw new ArgumentException("KeyComparer.Compare.x :: " + (x != null ? x.GetType().ToString() : "<null>"));
			}
		}

		
		public class Podsumowanie : ICustomTypeDescriptor
		{
			private readonly object kategoria;
			private Session session = null;
			DictionaryZero<string, NettoVATBrutto> wgStawek = new DictionaryZero<string, NettoVATBrutto>();
			NettoVATBrutto suma = new NettoVATBrutto(0, 0, 0);


			string ICustomTypeDescriptor.GetComponentName()
			{ return TypeDescriptor.GetComponentName(this, true); }

			object ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd)
			{ return this; }

			PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties(System.Attribute[] attributes)
			{ return TypeDescriptor.GetProperties(this, attributes, true); }

			PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties()
			{
				PropertyDescriptorCollection pdc = new PropertyDescriptorCollection(null);
				foreach (PropertyDescriptor pd in TypeDescriptor.GetProperties(this, true))
					pdc.Add(pd);

				foreach (string kodStawki in GetNames(session))
					pdc.Add(new NettoVATBruttoDescriptor(this, kodStawki));
				return pdc;
			}

			PropertyDescriptor ICustomTypeDescriptor.GetDefaultProperty()
			{ return TypeDescriptor.GetDefaultProperty(this, true); }

			object ICustomTypeDescriptor.GetEditor(System.Type editorBaseType)
			{ return TypeDescriptor.GetEditor(this, editorBaseType, true); }

			EventDescriptor ICustomTypeDescriptor.GetDefaultEvent()
			{ return TypeDescriptor.GetDefaultEvent(this, true); }

			TypeConverter ICustomTypeDescriptor.GetConverter()
			{ return TypeDescriptor.GetConverter(this, true); }

			EventDescriptorCollection ICustomTypeDescriptor.GetEvents(System.Attribute[] attributes)
			{ return TypeDescriptor.GetEvents(this, attributes, true); }

			EventDescriptorCollection ICustomTypeDescriptor.GetEvents()
			{ return TypeDescriptor.GetEvents(this, true); }

			System.ComponentModel.AttributeCollection ICustomTypeDescriptor.GetAttributes()
			{ return TypeDescriptor.GetAttributes(this, true); }

			string ICustomTypeDescriptor.GetClassName()
			{ return TypeDescriptor.GetClassName(this, true); }


			public class NettoVATBruttoDescriptor : PropertyDescriptor
			{
				private readonly Podsumowanie podsumowanie;
				private readonly string kodStawki;

				internal NettoVATBruttoDescriptor(Podsumowanie podsumowanie, string kodStawki)
					: base(kodStawki, null)
				{
					this.podsumowanie = podsumowanie;
					this.kodStawki = kodStawki;
				}

				public override bool IsReadOnly
				{ get { return true; } }

				public override Type PropertyType
				{ get { return typeof(NettoVATBrutto); } }

				public override System.ComponentModel.AttributeCollection Attributes
				{ get { return new System.ComponentModel.AttributeCollection(null); } }

				public override Type ComponentType
				{ get { return typeof(Podsumowanie); } }

				public override bool CanResetValue(object podsumowanie)
				{
					System.Diagnostics.Debug.Assert(podsumowanie == this.podsumowanie);
					return false;
				}

				public override object GetValue(object podsumowanie)
				{
					System.Diagnostics.Debug.Assert(podsumowanie == this.podsumowanie);
					return ((Podsumowanie)podsumowanie)[kodStawki];
				}

				public override void ResetValue(object podsumowanie)
				{ throw new InvalidOperationException(); }

				public override void SetValue(object podsumowanie, object value)
				{ throw new InvalidOperationException(); }

				public override bool ShouldSerializeValue(object blok)
				{ return false; }
			}


			public Podsumowanie(object kategoria)
			{ this.kategoria = kategoria; }

			public object Kategoria
			{ get { return kategoria; } }

			
			public void Add(PodsumowanieVATEx podsumowanie)
			{
				if (session == null)
					session = podsumowanie.Naglowek.Session;
				
				Soneta.EwidencjaVat.NettoVATBrutto s = podsumowanie.Suma;
				suma.Add(s.Netto, s.VAT, s.Brutto);
				
				foreach (string kodStawki in NettoVATBruttoWgStawek.GetNames(podsumowanie.Naglowek.Session))
				{
					s = podsumowanie.SumaWgStawek[kodStawki];
					if (wgStawek.ContainsKey(kodStawki))
						wgStawek[kodStawki].Add(s.Netto, s.VAT, s.Brutto);
					else
						wgStawek.Add(kodStawki, new NettoVATBrutto(s.Netto, s.VAT, s.Brutto));
				}
			}


			public static IEnumerable GetNames(Session session)
			{
				ArrayList arr = new ArrayList();
				foreach (DefinicjaStawkiVat def in CoreModule.GetInstance(session).DefStawekVat)
					arr.Add(def.Kod);
				return arr;
			}


			public NettoVATBrutto this[string kodStawki]
			{
				get
				{
					if (wgStawek.ContainsKey(kodStawki))
						return wgStawek[kodStawki];
					return new NettoVATBrutto(0, 0, 0);
				}
			}

			
			public NettoVATBrutto Suma
			{ get { return suma; } }
		}

		
		public class NettoVATBrutto
		{
			Currency netto, vat, brutto;

			public NettoVATBrutto(Currency netto, Currency vat, Currency brutto)
			{
				this.netto = netto;
				this.vat = vat;
				this.brutto = brutto;
			}

			public void Add(Currency netto, Currency vat, Currency brutto)
			{
				this.netto += netto;
				this.vat += vat;
				this.brutto += brutto;
			}

			public Currency Netto { get { return netto; } }
			public Currency VAT { get { return vat; } }
			public Currency Brutto { get { return brutto; } }

		}

		[Context]
		public Params Param { get; set; }

		
		public enum SposobSumowania
		{
			[Caption("-- Brak --")]
			Brak,
			[Caption("Miesiąc zaewidencjonowania")]
			WgMiesiącaZaewidencjonowania,
			[Caption("Miesiąc rozliczenia")]
			WgMiesiącaRozliczenia,
			[Caption("Miesiąc wpływu")]
			WgMiesiącaWpływu,
			[Caption("Miesiąc ewidencji")]
			WgMiesiącaEwidencji,
			[Caption("Miesiąc dokumentu")]
			WgMiesiącaDokumentu,
			[Caption("Miesiąc operacji")]
			WgMiesiącaOperacji,
			[Caption("Podmiot (EuVAT)")]
			WgPodmiotu,
			[Caption("Oddział")]
			WgOddziałów,
		}


		public enum ZakresDrukuTp
		{
			[Caption("Szczegóły")]
			List,
			[Caption("Szczegóły + Podsumowanie")]
			ListSummary,
			[Caption("Szczegóły (gr.)")]
			ListGrouped,
			[Caption("Szczegóły (gr.) + Podsumowanie")]
			ListGroupedSummary,
			[Caption("Podsumowanie")]
			SummaryOnly,
		}

		
		public class Params : SerializableContextBase
		{
			private Boolean zaplacone = false;
			private Boolean opisUslugi = false;
			private ZakresDrukuTp zakresDruku = ZakresDrukuTp.List;
			private DefinicjaStawkiVat[] definicjeStawekVAT = null;
			private FromTo okresRozliczeniaVAT = FromTo.All;
			private FromTo okresKsiegowania = FromTo.All;
			private SposobSumowania sposobSumowania = SposobSumowania.Brak;
			
						
			public Params(Context cx)
				: base(cx)
			{}

		    private bool IsPulpitKB()
		    {
		        return Context.Login.IsWebUser;
		    }

		    [Caption("Tylko zapłacone")]
			[Priority(10)]
			public bool Zaplacone
			{
				get { return zaplacone; }
				set { zaplacone = value; }
			}

		    public bool IsVisibleZaplacone()
		    {
		        return !IsPulpitKB();
		    }

		    [Caption("Opisy VAT usług")]
			[Priority(20)]
			public bool OpisUslugi
			{
				get { return opisUslugi; }
				set { opisUslugi = value; }
			}

		    public bool IsVisibleOpisUslugi()
		    {
		        return !IsPulpitKB();
		    }	

			[Soneta.Business.Required]
			[Caption("Kolumny(stawki VAT)")]
			[Priority(30)]
			[DefaultWidth(25)]
			public DefinicjaStawkiVat[] DefinicjeStawekVAT
			{
				get { return definicjeStawekVAT; }
				set { definicjeStawekVAT = value; }
			}

			
			public LookupInfo.Item GetListDefinicjeStawekVAT()
			{
				var coreModule = CoreModule.GetInstance(Session);

				var view = coreModule.DefStawekVat.CreateDefaultView();
				view.Condition &= new FieldCondition.NotEqual("Stawka.Procent", new Percent(0));
				view.Condition &= new FieldCondition.Equal("Stawka.Kraj", coreModule.KrajeTbl.Poland);

				return CoreModule.GetInstance(Session).DefStawekVat.GetDefaultLookup(view);
			}

			
			[Caption("Okres rozlicz. VAT ")]
			[Priority(40)]
			[DefaultWidth(25)]
			public FromTo OkresRozliczeniaVAT
			{
				get { return okresRozliczeniaVAT; }
				set
				{
					if (value == FromTo.Empty)
						value = FromTo.All;
					okresRozliczeniaVAT = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Caption("Okres księgowania")]
			[Priority(50)]
			[DefaultWidth(25)]
			public FromTo OkresKsiegowania
			{
				get { return okresKsiegowania; }
				set
				{
					if (value == FromTo.Empty)
						value = FromTo.All;

					okresKsiegowania = value; OnChanged(EventArgs.Empty);
				}
			}

		    public bool IsVisibleOkresKsiegowania()
		    {
		        return !IsPulpitKB();
		    }	
			
			[Caption("Kryterium")]
			[Priority(60)]
			[DefaultWidth(25)]
			public SposobSumowania SposobSumowania
			{
				get { return sposobSumowania; }
				set
				{
					sposobSumowania = value;

					if (sposobSumowania == SposobSumowania.Brak)
						zakresDruku = ZakresDrukuTp.List;
					else if (zakresDruku == ZakresDrukuTp.List)
						zakresDruku = ZakresDrukuTp.ListSummary;
						
					OnChanged(EventArgs.Empty);
				}
			}

			
			public object[] GetListSposobSumowania()
			{
				System.Collections.ArrayList list =  new ArrayList(Enum.GetValues(typeof(SposobSumowania)));
				
				if (!CoreModule.GetInstance(Session).DokEwidencja.Wielooddziałowość)
					list.Remove(SposobSumowania.WgOddziałów);

				return list.ToArray();
			}


			[Caption("Zakres wydruku")]
			[Priority(70)]
			[DefaultWidth(25)]
			public ZakresDrukuTp ZakresDruku
			{
				get { return zakresDruku; }
				set
				{
					zakresDruku = value;
					OnChanged(EventArgs.Empty);
				}
			}


			public Boolean IsReadOnlyZakresDruku()
			{ return sposobSumowania == SposobSumowania.Brak; }
		}
	}
}
